/*
 * Decompiled with CFR 0.152.
 */
package zhcn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Translator {
    private static Map<String, Translator> map = new HashMap<String, Translator>();
    String file = "cn.txt";
    boolean debug;
    Map<String, String> literal = new HashMap<String, String>();
    Map<Pattern, String> regexp = new HashMap<Pattern, String>();

    public static String translate(String langfile, String str) throws Exception {
        Translator translator = map.get(langfile);
        if (translator == null) {
            translator = new Translator(langfile);
            map.put(langfile, translator);
        }
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder();
        for (String s : str.split("\n")) {
            if (ret.length() > 0) {
                ret.append("\n");
            }
            ret.append(translator.translate(s));
        }
        return ret.toString();
    }

    Translator(String langfile) throws Exception {
        if (langfile != null && langfile.equals("debug")) {
            this.debug = true;
        }
        if (langfile != null && new File(langfile).isFile()) {
            this.file = langfile;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            System.out.println("\u68c0\u6d4b\u5230\u6839\u76ee\u5f55\u4e0b\u6709\u7ffb\u8bd1\u6587\u4ef6\uff0c\u8bfb\u53d6\u5305\u5185\u6587\u4ef6\u3002");
            Pattern pattern = Pattern.compile(".*\\$[0-9].*");
            while ((line = reader.readLine()) != null) {
                String[] inputs = line.split("\t", 2);
                this.literal.put(inputs[0], inputs[1]);
                if (!pattern.matcher(inputs[1]).matches()) continue;
                String re = "(?m)^" + inputs[0] + "$";
                try {
                    this.regexp.put(Pattern.compile(re), inputs[1].replace("\"", "\\\""));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            String line;
            System.out.println("\u672a\u68c0\u6d4b\u5230\u6839\u76ee\u5f55\u4e0b\u6709\u7ffb\u8bd1\u6587\u4ef6\uff0c\u8bfb\u53d6\u5305\u5185\u6587\u4ef6\u3002");
            InputStream resource = Translator.class.getResourceAsStream("resources/cn.txt");
            BufferedReader readers = new BufferedReader(new InputStreamReader(resource));
            Pattern pattern = Pattern.compile(".*\\$[0-9].*");
            while ((line = readers.readLine()) != null) {
                String[] inputs = line.split("\t", 2);
                this.literal.put(inputs[0], inputs[1]);
                if (!pattern.matcher(inputs[1]).matches()) continue;
                String re = "(?m)^" + inputs[0] + "$";
                try {
                    this.regexp.put(Pattern.compile(re), inputs[1].replace("\"", "\\\""));
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
            readers.close();
        }
    }

    String translate(String src) {
        if (src == null || src.length() == 0) {
            return src;
        }
        String dst = this.literal.get(src);
        if (dst == null) {
            dst = src;
            for (Map.Entry<Pattern, String> entry : this.regexp.entrySet()) {
                Pattern pattern = entry.getKey();
                Matcher matcher = pattern.matcher(dst);
                dst = matcher.replaceAll(entry.getValue());
            }
        }
        if (!(!this.debug || !src.equals(dst) || dst.length() != dst.getBytes().length || src.matches("https?://.+") || src.matches("\\$?[ 0-9,./:]+") || src.matches("^[-.\\w]+:?$") || src.matches("burp\\..*") || src.matches("lbl.*") || src.length() <= 1 || src.matches("[- A-Z]+s?") || src.matches("\\s+"))) {
            System.err.println("[" + src + "]");
        }
        return dst;
    }
}

